/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.icf.connector.upstream.ad.schema;

import com.bamboocloud.icf.common.security.GuardedString;
import com.bamboocloud.icf.common.security.SecurityUtil;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;

public abstract class GuardedPasswordAttribute {
    public static GuardedPasswordAttribute create(String attrName, GuardedString password) {
        return new Simple(attrName, password);
    }

    public static GuardedPasswordAttribute create(String attrName) {
        return new Empty(attrName);
    }

    public abstract void access(Accessor var1);

    private static final class Simple
    extends GuardedPasswordAttribute {
        private final String attrName;
        private final GuardedString password;

        private Simple(String attrName, GuardedString password) {
            this.attrName = attrName;
            this.password = password;
        }

        @Override
        public void access(final Accessor accessor) {
            this.password.access(new GuardedString.Accessor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void access(char[] clearChars) {
                    CharBuffer charBuf = CharBuffer.wrap(clearChars);
                    ByteBuffer byteBuf = Charset.forName("UTF-8").encode(charBuf);
                    try {
                        byteBuf.rewind();
                        byte[] bytes = new byte[byteBuf.limit()];
                        byteBuf.get(bytes);
                        try {
                            BasicAttribute attr = new BasicAttribute(attrName, bytes);
                            accessor.access(attr);
                        }
                        finally {
                            SecurityUtil.clear((byte[])bytes);
                        }
                    }
                    finally {
                        byteBuf.rewind();
                        while (byteBuf.remaining() > 0) {
                            byteBuf.put((byte)0);
                        }
                    }
                }
            });
        }
    }

    private static final class Empty
    extends GuardedPasswordAttribute {
        private final String attrName;

        private Empty(String attrName) {
            this.attrName = attrName;
        }

        @Override
        public void access(Accessor accessor) {
            accessor.access(new BasicAttribute(this.attrName));
        }
    }

    public static interface Accessor {
        public void access(Attribute var1);
    }
}

