/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.icf.connector.upstream.ad.schema;

import com.bamboocloud.icf.common.logging.Log;
import com.bamboocloud.icf.connector.upstream.ad.AdConnection;
import com.bamboocloud.icf.connector.upstream.ad.AdConnector;
import com.bamboocloud.icf.connector.upstream.ad.commons.LdapAttributeType;
import com.bamboocloud.icf.connector.upstream.ad.commons.LdapNativeSchema;
import com.bamboocloud.icf.connector.upstream.ad.commons.ObjectClassMappingConfig;
import com.bamboocloud.icf.framework.common.objects.AttributeInfo;
import com.bamboocloud.icf.framework.common.objects.ObjectClass;
import com.bamboocloud.icf.framework.common.objects.ObjectClassInfo;
import com.bamboocloud.icf.framework.common.objects.ObjectClassInfoBuilder;
import com.bamboocloud.icf.framework.common.objects.OperationOptionInfoBuilder;
import com.bamboocloud.icf.framework.common.objects.Schema;
import com.bamboocloud.icf.framework.common.objects.SchemaBuilder;
import com.bamboocloud.icf.framework.spi.operations.AuthenticateOp;
import com.bamboocloud.icf.framework.spi.operations.CreateOp;
import com.bamboocloud.icf.framework.spi.operations.DeleteOp;
import com.bamboocloud.icf.framework.spi.operations.SearchOp;
import com.bamboocloud.icf.framework.spi.operations.SyncOp;
import com.bamboocloud.icf.framework.spi.operations.UpdateOp;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

class LdapSchemaBuilder {
    private static final Log log = Log.getLog(LdapSchemaBuilder.class);
    private final AdConnection conn;
    private final LdapNativeSchema nativeSchema;
    private Schema schema;

    public LdapSchemaBuilder(AdConnection conn) {
        this.conn = conn;
        this.nativeSchema = conn.createNativeSchema();
    }

    public Schema getSchema() {
        if (this.schema == null) {
            this.buildSchema();
        }
        return this.schema;
    }

    private void buildSchema() {
        SchemaBuilder schemaBld = new SchemaBuilder(AdConnector.class);
        for (ObjectClassMappingConfig oclassConfig : this.conn.getConfiguration().getObjectClassMappingConfigs().values()) {
            ObjectClass oclass = oclassConfig.getObjectClass();
            ObjectClassInfoBuilder objClassBld = new ObjectClassInfoBuilder();
            objClassBld.setType(oclass.getObjectClassValue());
            objClassBld.setContainer(oclassConfig.isContainer());
            objClassBld.addAllAttributeInfo(this.createAttributeInfos(oclassConfig.getLdapClasses()));
            objClassBld.addAllAttributeInfo(oclassConfig.getOperationalAttributes());
            ObjectClassInfo oci = objClassBld.build();
            schemaBld.defineObjectClass(oci);
            if (!oci.is(ObjectClass.ACCOUNT_NAME)) {
                schemaBld.removeSupportedObjectClass(AuthenticateOp.class, oci);
            }
            if (this.conn.getServerType() == AdConnection.ServerType.OPENDJ) {
                schemaBld.removeSupportedObjectClass(SyncOp.class, oci);
            }
            if (oci.is(ObjectClass.ACCOUNT_NAME)) {
                schemaBld.defineOperationOption(OperationOptionInfoBuilder.build((String)oci.getType()), new Class[]{CreateOp.class, UpdateOp.class, DeleteOp.class, SearchOp.class});
                continue;
            }
            if (oci.is(ObjectClass.ORGANIZATION_NAME)) {
                schemaBld.defineOperationOption(OperationOptionInfoBuilder.build((String)oci.getType()), new Class[]{CreateOp.class, UpdateOp.class, DeleteOp.class, SearchOp.class});
                continue;
            }
            if (!oci.is(ObjectClass.GROUP_NAME)) continue;
            schemaBld.defineOperationOption(OperationOptionInfoBuilder.build((String)oci.getType()), new Class[]{SearchOp.class});
        }
        this.schema = schemaBld.build();
    }

    private Set<AttributeInfo> createAttributeInfos(Collection<String> ldapClasses) {
        HashSet<AttributeInfo> result = new HashSet<AttributeInfo>();
        Set<String> requiredAttrs = this.getRequiredAttributes(ldapClasses);
        Set<String> optionalAttrs = this.getOptionalAttributes(ldapClasses);
        optionalAttrs.removeAll(requiredAttrs);
        this.addAttributeInfos(ldapClasses, requiredAttrs, EnumSet.of(AttributeInfo.Flags.REQUIRED), null, result);
        this.addAttributeInfos(ldapClasses, optionalAttrs, null, null, result);
        return result;
    }

    private Set<String> getRequiredAttributes(Collection<String> ldapClasses) {
        HashSet<String> result = new HashSet<String>();
        for (String ldapClass : ldapClasses) {
            result.addAll(this.nativeSchema.getRequiredAttributes(ldapClass));
        }
        return result;
    }

    private Set<String> getOptionalAttributes(Collection<String> ldapClasses) {
        HashSet<String> result = new HashSet<String>();
        for (String ldapClass : ldapClasses) {
            result.addAll(this.nativeSchema.getOptionalAttributes(ldapClass));
        }
        return result;
    }

    private void addAttributeInfos(Collection<String> ldapClasses, Set<String> attrs, Set<AttributeInfo.Flags> add, Set<AttributeInfo.Flags> remove, Set<AttributeInfo> toSet) {
        for (String attr : attrs) {
            this.addAttributeInfo(ldapClasses, attr, attr, add, remove, toSet);
        }
    }

    private void addAttributeInfo(Collection<String> ldapClasses, String ldapAttrName, String realName, Set<AttributeInfo.Flags> add, Set<AttributeInfo.Flags> remove, Set<AttributeInfo> toSet) {
        LdapAttributeType attrDesc = this.nativeSchema.getAttributeDescription(ldapAttrName);
        if (attrDesc != null) {
            toSet.add(attrDesc.createAttributeInfo(realName, add, remove));
        } else {
            log.warn("Could not find attribute {0} in object classes {1}", new Object[]{ldapAttrName, ldapClasses});
        }
    }
}

