/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.icf.connector.upstream.ad.search;

import com.bamboocloud.icf.common.StringUtil;
import com.bamboocloud.icf.connector.upstream.ad.AdConnection;
import com.bamboocloud.icf.connector.upstream.ad.search.LdapSearchResultsHandler;
import com.bamboocloud.icf.connector.upstream.ad.search.LdapSearchStrategy;
import com.bamboocloud.icf.framework.common.exceptions.ConnectorUnKnownException;
import java.io.IOException;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;

public class LdapInternalSearch {
    private final AdConnection conn;
    private final String filter;
    private final List<String> baseDNs;
    private final LdapSearchStrategy strategy;
    private final SearchControls controls;

    public LdapInternalSearch(AdConnection conn, String filter, List<String> baseDNs, LdapSearchStrategy strategy, SearchControls controls) {
        this.conn = conn;
        this.filter = StringUtil.isNotBlank((String)filter) ? filter : "(objectClass=*)";
        this.baseDNs = baseDNs;
        this.strategy = strategy;
        this.controls = controls;
    }

    public void execute(LdapSearchResultsHandler handler) {
        try {
            this.strategy.doSearch(this.conn.getInitialContext(), this.baseDNs, this.filter, this.controls, handler);
        }
        catch (IOException e) {
            throw new ConnectorUnKnownException((Throwable)e);
        }
        catch (NamingException e) {
            throw new ConnectorUnKnownException((Throwable)e);
        }
    }

    public static SearchControls createDefaultSearchControls() {
        SearchControls result = new SearchControls();
        result.setCountLimit(0L);
        result.setDerefLinkFlag(true);
        result.setReturningObjFlag(false);
        result.setTimeLimit(0);
        return result;
    }
}

