/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.icf.connector.upstream.ad.search;

import com.bamboocloud.icf.common.logging.Log;
import com.bamboocloud.icf.connector.upstream.ad.AdConnection;
import com.bamboocloud.icf.connector.upstream.ad.commons.ADLdapUtil;
import com.bamboocloud.icf.connector.upstream.ad.commons.LdapEntry;
import com.bamboocloud.icf.connector.upstream.ad.commons.LdapUtil;
import com.bamboocloud.icf.connector.upstream.ad.search.LdapFilter;
import com.bamboocloud.icf.connector.upstream.ad.search.LdapFilterTranslator;
import com.bamboocloud.icf.connector.upstream.ad.search.LdapInternalSearch;
import com.bamboocloud.icf.connector.upstream.ad.search.LdapSearch;
import com.bamboocloud.icf.connector.upstream.ad.search.LdapSearchResultsHandler;
import com.bamboocloud.icf.framework.common.exceptions.APIFailedException;
import com.bamboocloud.icf.framework.common.exceptions.ObjectNotExistsException;
import com.bamboocloud.icf.framework.common.objects.Attribute;
import com.bamboocloud.icf.framework.common.objects.AttributeUtil;
import com.bamboocloud.icf.framework.common.objects.ConnectorObject;
import com.bamboocloud.icf.framework.common.objects.ObjectClass;
import com.bamboocloud.icf.framework.common.objects.OperationOptionsBuilder;
import com.bamboocloud.icf.framework.common.objects.ResultsHandler;
import com.bamboocloud.icf.framework.common.objects.attributes.Uid;
import com.bamboocloud.icf.framework.common.objects.filter.EqualsFilter;
import com.bamboocloud.icf.framework.common.objects.filter.FilterBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;

public final class LdapSearches {
    private static final Log LOG = Log.getLog(LdapSearches.class);

    private LdapSearches() {
    }

    public static String getEntryDN(AdConnection conn, ObjectClass oclass, Uid uid) {
        return LdapSearches.findEntryDN(conn, oclass, uid, true);
    }

    public static String findEntryDN(AdConnection conn, ObjectClass oclass, Uid uid) {
        return LdapSearches.findEntryDN(conn, oclass, uid, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String findEntryDN(AdConnection conn, ObjectClass oclass, Uid uid, boolean check) {
        LdapSearch search;
        ConnectorObject object;
        LOG.ok("Searching for object {0} of class {1}", new Object[]{uid.getSingleValue(), oclass.getObjectClassValue()});
        LdapFilter ldapFilter = null;
        String uidAttr = conn.getSchemaMapping().getLdapUidAttribute(oclass);
        if (LdapEntry.isDNAttribute(uidAttr)) {
            if (!check) return uid.getSingleValue();
            ldapFilter = LdapFilter.forEntryDN(uid.getSingleValue());
        } else {
            EqualsFilter filter = (EqualsFilter)FilterBuilder.equalTo((Attribute)uid);
            ldapFilter = new LdapFilterTranslator(conn.getSchemaMapping(), oclass).createEqualsExpression(filter, false);
        }
        assert (ldapFilter != null);
        OperationOptionsBuilder builder = new OperationOptionsBuilder();
        builder.setAttributesToGet(new String[]{conn.getConfiguration().getDnAttribute()});
        if ("objectGUID".equals(uidAttr)) {
            String objectGuid = "(objectGUID=" + ADLdapUtil.guidDashedStringtoByteString(uid.getSingleValue()) + ")";
            ldapFilter = LdapFilter.forNativeFilter(objectGuid);
        }
        if ((object = (search = new LdapSearch(conn, oclass, ldapFilter, null, builder.build())).getSingleResult()) == null) throw new ObjectNotExistsException("ad.remote.object.not.exist", new String[]{uid.getSingleValue()});
        return AttributeUtil.getStringValue((Attribute)object.getAttributeByName(conn.getConfiguration().getDnAttribute()));
    }

    public static List<ConnectorObject> findObjects(AdConnection conn, ObjectClass oclass, String baseDN, Attribute attr, String ... attrsToGet) {
        LOG.ok("Searching for object with attribute {0} of class {1} in {2}", new Object[]{attr, oclass.getObjectClassValue(), baseDN});
        final ArrayList<ConnectorObject> result = new ArrayList<ConnectorObject>();
        EqualsFilter filter = (EqualsFilter)FilterBuilder.equalTo((Attribute)attr);
        LdapFilter ldapFilter = new LdapFilterTranslator(conn.getSchemaMapping(), oclass).createEqualsExpression(filter, false);
        OperationOptionsBuilder builder = new OperationOptionsBuilder();
        builder.setAttributesToGet(attrsToGet);
        LdapSearch search = new LdapSearch(conn, oclass, ldapFilter, new ResultsHandler(){

            public boolean handle(ConnectorObject object) {
                result.add(object);
                return true;
            }
        }, builder.build(), baseDN);
        search.execute();
        return result;
    }

    public static ConnectorObject findObject(AdConnection conn, ObjectClass oclass, LdapFilter filter, String ... attrsToGet) {
        LOG.ok("Searching for object of class {0} with filter {1}", new Object[]{oclass.getObjectClassValue(), filter});
        OperationOptionsBuilder builder = new OperationOptionsBuilder();
        builder.setAttributesToGet(attrsToGet);
        LdapSearch search = new LdapSearch(conn, oclass, filter, null, builder.build());
        return search.getSingleResult();
    }

    public static LdapEntry getEntry(AdConnection conn, LdapName entryDN, String ... ldapAttrsToGet) {
        LOG.ok("Searching for entry {0}", new Object[]{entryDN});
        final ArrayList result = new ArrayList();
        if (!LdapUtil.isUnderContexts(entryDN, conn.getConfiguration().getBaseContextsAsLdapNames())) {
            return null;
        }
        SearchControls controls = LdapInternalSearch.createDefaultSearchControls();
        controls.setSearchScope(0);
        controls.setReturningAttributes(ldapAttrsToGet);
        LdapInternalSearch search = new LdapInternalSearch(conn, null, Collections.singletonList(entryDN.toString()), conn.getConfiguration().newDefaultSearchStrategy(true), controls);
        search.execute(new LdapSearchResultsHandler(){

            @Override
            public boolean handle(String baseDN, SearchResult searchResult) {
                result.add(LdapEntry.create(baseDN, searchResult));
                return false;
            }
        });
        if (!result.isEmpty()) {
            return (LdapEntry)result.get(0);
        }
        throw new APIFailedException("ad.entryNotFound", new String[]{entryDN.toString()});
    }

    public static void findEntries(LdapSearchResultsHandler handler, AdConnection conn, String filter, String ... ldapAttrsToGet) {
        LOG.ok("Searching for entries matching {0}", new Object[]{filter});
        ArrayList<String> dns = new ArrayList<String>();
        List<String> baseDNs = Arrays.asList(conn.getConfiguration().getBaseContexts());
        dns.addAll(baseDNs);
        String[] groupBaseContexts = conn.getConfiguration().getGroupBaseContexts();
        if (groupBaseContexts != null && groupBaseContexts.length > 0) {
            List<String> groupDNs = Arrays.asList(groupBaseContexts);
            dns.addAll(groupDNs);
        }
        SearchControls controls = LdapInternalSearch.createDefaultSearchControls();
        controls.setSearchScope(2);
        controls.setReturningAttributes(ldapAttrsToGet);
        LdapInternalSearch search = new LdapInternalSearch(conn, filter, dns, conn.getConfiguration().newDefaultSearchStrategy(false), controls);
        search.execute(handler);
    }
}

