/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.icf.connector.upstream.ad.sync.sunds;

import com.bamboocloud.icf.common.Assertions;
import com.bamboocloud.icf.common.logging.Log;
import com.bamboocloud.icf.framework.common.exceptions.ConnectionFailedException;
import com.bamboocloud.icf.framework.common.exceptions.ConnectorException;
import com.bamboocloud.icf.framework.common.exceptions.ConnectorUnKnownException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class PasswordDecryptor {
    private static final Log LOG = Log.getLog(PasswordDecryptor.class);
    private static final String ENCRYPTION_ALGORITHM = "DESede/CBC/NoPadding";
    private static final int KEY_VERSION_MAGIC = 321721347;
    private static final int LENGTH_INDEX = 4;
    private final Cipher cipher;
    private final int blockSize;

    public PasswordDecryptor(byte[] desedeKey, byte[] iv) {
        Assertions.nullCheck((Object)desedeKey, (String)"desedeKey");
        Assertions.nullCheck((Object)iv, (String)"iv");
        IvParameterSpec ivspec = new IvParameterSpec(iv);
        SecretKeySpec keyspec = new SecretKeySpec(desedeKey, "DESede");
        try {
            this.cipher = Cipher.getInstance(ENCRYPTION_ALGORITHM);
            this.cipher.init(2, (Key)keyspec, ivspec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ConnectionFailedException((Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            throw new ConnectionFailedException((Throwable)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new ConnectionFailedException((Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new ConnectionFailedException((Throwable)e);
        }
        this.blockSize = this.cipher.getBlockSize();
    }

    public String decryptPassword(byte[] encryptedPassword) {
        byte[] decryptedBytes;
        byte[] decryptInput;
        if (encryptedPassword.length % this.blockSize != 0) {
            decryptInput = new byte[(encryptedPassword.length / this.blockSize + 1) * this.blockSize];
            System.arraycopy(encryptedPassword, 0, decryptInput, 0, encryptedPassword.length);
            Arrays.fill(decryptInput, encryptedPassword.length, decryptInput.length, (byte)0);
        } else {
            decryptInput = encryptedPassword;
        }
        try {
            decryptedBytes = this.cipher.doFinal(decryptInput);
        }
        catch (IllegalStateException e) {
            throw new ConnectionFailedException((Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            throw new ConnectionFailedException((Throwable)e);
        }
        catch (BadPaddingException e) {
            throw new ConnectionFailedException((Throwable)e);
        }
        try {
            return this.getDecryptedPassword(decryptedBytes);
        }
        catch (UnsupportedEncodingException e) {
            throw new ConnectorUnKnownException((Throwable)e);
        }
    }

    private final String getDecryptedPassword(byte[] password) throws ConnectorException, UnsupportedEncodingException {
        if (password.length < 8) {
            throw new ConnectorUnKnownException("Invalid decrypted password value: too short");
        }
        int len = this.getIntValueFromByteArray(password, 4);
        if (len < 0) {
            throw new ConnectorUnKnownException("Weird decrypted password value: negative length");
        }
        if (len <= password.length - 12 - this.blockSize || len > password.length - 12) {
            throw new ConnectorUnKnownException("Invalid password length");
        }
        this.checkKeyVersionMagic(password, 8 + len);
        return new String(password, 8, len, Charset.forName("UTF-8"));
    }

    private final void checkKeyVersionMagic(byte[] password, int postMagicIndex) throws ConnectorException {
        if (postMagicIndex < 8 || postMagicIndex > password.length - 4) {
            throw new ConnectorUnKnownException("Invalid start index for post password magic");
        }
        int premagic = this.getIntValueFromByteArray(password, 0);
        int postmagic = this.getIntValueFromByteArray(password, postMagicIndex);
        if (premagic != 321721347 || postmagic != 321721347) {
            throw new ConnectorUnKnownException("Key magic mismatch");
        }
    }

    private int getIntValueFromByteArray(byte[] bytes, int index) {
        return (this.getUnsignedByteValueAsInt(bytes[index]) << 24) + (this.getUnsignedByteValueAsInt(bytes[index + 1]) << 16) + (this.getUnsignedByteValueAsInt(bytes[index + 2]) << 8) + this.getUnsignedByteValueAsInt(bytes[index + 3]);
    }

    private int getUnsignedByteValueAsInt(byte b) {
        if (b < 0) {
            return 256 + b;
        }
        return b;
    }
}

