/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.icf.connector.upstream.ad.sync.sunds;

import com.bamboocloud.icf.common.Base64;
import com.bamboocloud.icf.common.CollectionUtil;
import com.bamboocloud.icf.common.StringUtil;
import com.bamboocloud.icf.common.logging.Log;
import com.bamboocloud.icf.common.security.GuardedString;
import com.bamboocloud.icf.connector.upstream.ad.AdConnection;
import com.bamboocloud.icf.connector.upstream.ad.commons.LdapEntry;
import com.bamboocloud.icf.connector.upstream.ad.commons.LdapUtil;
import com.bamboocloud.icf.connector.upstream.ad.search.LdapFilter;
import com.bamboocloud.icf.connector.upstream.ad.search.LdapInternalSearch;
import com.bamboocloud.icf.connector.upstream.ad.search.LdapSearch;
import com.bamboocloud.icf.connector.upstream.ad.search.LdapSearchResultsHandler;
import com.bamboocloud.icf.connector.upstream.ad.search.LdapSearches;
import com.bamboocloud.icf.connector.upstream.ad.sync.LdapSyncStrategy;
import com.bamboocloud.icf.connector.upstream.ad.sync.sunds.ChangeLogAttributes;
import com.bamboocloud.icf.connector.upstream.ad.sync.sunds.LdifParser;
import com.bamboocloud.icf.connector.upstream.ad.sync.sunds.PasswordDecryptor;
import com.bamboocloud.icf.framework.common.exceptions.ConfigurationException;
import com.bamboocloud.icf.framework.common.exceptions.ConnectorUnKnownException;
import com.bamboocloud.icf.framework.common.exceptions.InvalidAttributeValueException;
import com.bamboocloud.icf.framework.common.objects.Attribute;
import com.bamboocloud.icf.framework.common.objects.AttributeBuilder;
import com.bamboocloud.icf.framework.common.objects.ConnectorObject;
import com.bamboocloud.icf.framework.common.objects.ConnectorObjectBuilder;
import com.bamboocloud.icf.framework.common.objects.ObjectClass;
import com.bamboocloud.icf.framework.common.objects.OperationOptions;
import com.bamboocloud.icf.framework.common.objects.OperationalAttributes;
import com.bamboocloud.icf.framework.common.objects.SyncDelta;
import com.bamboocloud.icf.framework.common.objects.SyncDeltaBuilder;
import com.bamboocloud.icf.framework.common.objects.SyncDeltaType;
import com.bamboocloud.icf.framework.common.objects.SyncResultsHandler;
import com.bamboocloud.icf.framework.common.objects.SyncToken;
import com.bamboocloud.icf.framework.common.objects.attributes.Uid;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;

public class SunDSChangeLogSyncStrategy
implements LdapSyncStrategy {
    private static final Log LOG = Log.getLog(SunDSChangeLogSyncStrategy.class);
    private static final Set<String> LDIF_MODIFY_OPS = CollectionUtil.newCaseInsensitiveSet();
    private final AdConnection conn;
    private final ObjectClass oclass;
    private ChangeLogAttributes changeLogAttrs;
    private Set<String> oclassesToSync;
    private Set<String> attrsToSync;
    private PasswordDecryptor passwordDecryptor;

    public SunDSChangeLogSyncStrategy(AdConnection conn, ObjectClass oclass) {
        this.conn = conn;
        this.oclass = oclass;
    }

    @Override
    public SyncToken getLatestSyncToken() {
        return new SyncToken((Object)this.getChangeLogAttributes().getLastChangeNumber());
    }

    @Override
    public void sync(SyncToken token, final SyncResultsHandler handler, final OperationOptions options) {
        String context = this.getChangeLogAttributes().getChangeLogContext();
        final String changeNumberAttr = this.getChangeNumberAttribute();
        SearchControls controls = LdapInternalSearch.createDefaultSearchControls();
        controls.setSearchScope(1);
        controls.setReturningAttributes(new String[]{changeNumberAttr, "targetDN", "changeType", "changes", "newRdn", "deleteOldRdn", "newSuperior"});
        final int[] currentChangeNumber = new int[]{this.getStartChangeNumber(token)};
        final boolean[] results = new boolean[]{false};
        do {
            String filter = this.getChangeLogSearchFilter(changeNumberAttr, currentChangeNumber[0]);
            LdapInternalSearch search = new LdapInternalSearch(this.conn, filter, Collections.singletonList(context), this.conn.getConfiguration().newDefaultSearchStrategy(false), controls);
            search.execute(new LdapSearchResultsHandler(){

                @Override
                public boolean handle(String baseDN, SearchResult result) throws NamingException {
                    SyncDelta delta;
                    results[0] = true;
                    LdapEntry entry = LdapEntry.create(baseDN, result);
                    int changeNumber = SunDSChangeLogSyncStrategy.convertToInt(LdapUtil.getStringAttrValue(entry.getAttributes(), changeNumberAttr), -1);
                    if (changeNumber > currentChangeNumber[0]) {
                        currentChangeNumber[0] = changeNumber;
                    }
                    if ((delta = SunDSChangeLogSyncStrategy.this.createSyncDelta(entry, changeNumber, options.getAttributesToGet())) != null) {
                        return handler.handle(delta);
                    }
                    return true;
                }
            });
            if (!results[0]) continue;
            currentChangeNumber[0] = currentChangeNumber[0] + 1;
        } while (results[0]);
    }

    private SyncDelta createSyncDelta(LdapEntry changeLogEntry, int changeNumber, String[] attrsToGetOption) {
        String uidAttr;
        List<Object> passwordValues;
        Set attrsToGet;
        LOG.ok("Attempting to create sync delta for log entry {0}", new Object[]{changeNumber});
        String targetDN = LdapUtil.getStringAttrValue(changeLogEntry.getAttributes(), "targetDN");
        if (targetDN == null) {
            LOG.error("Skipping log entry because it does not have a targetDN attribute", new Object[0]);
            return null;
        }
        LdapName targetName = LdapUtil.quietCreateLdapName(targetDN);
        if (this.filterOutByBaseContexts(targetName)) {
            LOG.ok("Skipping log entry because it does not match any of the base contexts to synchronize", new Object[0]);
            return null;
        }
        String changeType = LdapUtil.getStringAttrValue(changeLogEntry.getAttributes(), "changeType");
        SyncDeltaType deltaType = this.getSyncDeltaType(changeType);
        SyncDeltaBuilder syncDeltaBuilder = new SyncDeltaBuilder();
        syncDeltaBuilder.setToken(new SyncToken((Object)changeNumber));
        syncDeltaBuilder.setDeltaType(deltaType);
        if (deltaType.equals((Object)SyncDeltaType.DELETE)) {
            LOG.ok("Creating sync delta for deleted entry", new Object[0]);
            String uidAttr2 = this.conn.getSchemaMapping().getLdapUidAttribute(this.oclass);
            if (!LdapEntry.isDNAttribute(uidAttr2)) {
                throw new InvalidAttributeValueException("Unsupported Uid attribute " + uidAttr2);
            }
            Uid deletedUid = this.conn.getSchemaMapping().createUid(this.oclass, targetDN);
            ConnectorObjectBuilder objectBuilder = new ConnectorObjectBuilder();
            objectBuilder.setObjectClass(this.oclass);
            objectBuilder.setUid(deletedUid);
            objectBuilder.setName("fake-dn");
            objectBuilder.addAttributes(Collections.emptySet());
            syncDeltaBuilder.setUid(deletedUid);
            syncDeltaBuilder.setObject(objectBuilder.build());
            return syncDeltaBuilder.build();
        }
        String changes = LdapUtil.getStringAttrValue(changeLogEntry.getAttributes(), "changes");
        Map<String, List<Object>> attrChanges = this.getAttributeChanges(changeType, changes);
        if (this.filterOutByModifiersNames(attrChanges)) {
            LOG.ok("Skipping entry because modifiersName is in the list of modifiersName's to filter out", new Object[0]);
            return null;
        }
        if (this.filterOutByAttributes(attrChanges)) {
            LOG.ok("Skipping entry because no changed attributes in the list of attributes to synchronize", new Object[0]);
            return null;
        }
        String newTargetDN = targetDN;
        if ("modrdn".equalsIgnoreCase(changeType)) {
            String newRdn = LdapUtil.getStringAttrValue(changeLogEntry.getAttributes(), "newRdn");
            if (StringUtil.isBlank((String)newRdn)) {
                LOG.error("Skipping log entry because it does not have a newRdn attribute", new Object[0]);
                return null;
            }
            String newSuperior = LdapUtil.getStringAttrValue(changeLogEntry.getAttributes(), "newSuperior");
            newTargetDN = this.getNewTargetDN(targetName, newSuperior, newRdn);
        }
        if (attrsToGetOption != null) {
            attrsToGet = CollectionUtil.newSet((Object[])attrsToGetOption);
            attrsToGet.remove(OperationalAttributes.PASSWORD_NAME);
        } else {
            attrsToGet = CollectionUtil.newSet(LdapSearch.getAttributesReturnedByDefault(this.conn, this.oclass));
        }
        boolean removeObjectClass = attrsToGet.add("objectClass");
        LdapFilter filter = LdapFilter.forEntryDN(newTargetDN).withNativeFilter(this.getModifiedEntrySearchFilter());
        ConnectorObject object = LdapSearches.findObject(this.conn, this.oclass, filter, attrsToGet.toArray(new String[attrsToGet.size()]));
        if (object == null) {
            LOG.ok("Skipping entry because the modified entry is missing, not of the right object class, or not matching the search filter", new Object[0]);
            return null;
        }
        Attribute oclassAttr = object.getAttributeByName("objectClass");
        List<String> objectClasses = LdapUtil.checkedListByFilter(CollectionUtil.nullAsEmpty((List)oclassAttr.getValue()), String.class);
        if (this.filterOutByObjectClasses(objectClasses)) {
            LOG.ok("Skipping entry because no object class in the list of object classes to synchronize", new Object[0]);
            return null;
        }
        Attribute passwordAttr = null;
        if (this.conn.getConfiguration().isSynchronizePasswords() && !(passwordValues = attrChanges.get(this.conn.getConfiguration().getPasswordAttributeToSynchronize())).isEmpty()) {
            byte[] encryptedPwd = (byte[])passwordValues.get(0);
            String decryptedPwd = this.getPasswordDecryptor().decryptPassword(encryptedPwd);
            passwordAttr = AttributeBuilder.buildPassword((GuardedString)new GuardedString(decryptedPwd.toCharArray()));
        }
        if (removeObjectClass || passwordAttr != null) {
            ConnectorObjectBuilder objectBuilder = new ConnectorObjectBuilder();
            objectBuilder.setObjectClass(object.getObjectClass());
            objectBuilder.setUid(object.getUid());
            objectBuilder.setName(object.getName());
            if (removeObjectClass) {
                for (Attribute attr : object.getAttributes()) {
                    if (attr == oclassAttr) continue;
                    objectBuilder.addAttribute(new Attribute[]{attr});
                }
            } else {
                objectBuilder.addAttributes((Collection)object.getAttributes());
            }
            if (passwordAttr != null) {
                objectBuilder.addAttribute(new Attribute[]{passwordAttr});
            }
            object = objectBuilder.build();
        }
        LOG.ok("Creating sync delta for created or updated entry", new Object[0]);
        if ("modrdn".equalsIgnoreCase(changeType) && LdapEntry.isDNAttribute(uidAttr = this.conn.getSchemaMapping().getLdapUidAttribute(this.oclass))) {
            syncDeltaBuilder.setPreviousUid(this.conn.getSchemaMapping().createUid(this.oclass, targetDN));
        }
        syncDeltaBuilder.setUid(object.getUid());
        syncDeltaBuilder.setObject(object);
        return syncDeltaBuilder.build();
    }

    private String getNewTargetDN(LdapName targetName, String newSuperior, String newRdn) {
        try {
            LdapName newTargetName;
            if (newSuperior == null) {
                newTargetName = new LdapName(targetName.getRdns());
                if (newTargetName.size() > 0) {
                    newTargetName.remove(targetName.size() - 1);
                }
            } else {
                newTargetName = LdapUtil.quietCreateLdapName(newSuperior);
            }
            newTargetName.add(newRdn);
            return newTargetName.toString();
        }
        catch (InvalidNameException e) {
            LOG.error((Throwable)e, "getNewTargetDN InvalidNameException", new Object[0]);
            throw new ConfigurationException((Throwable)e);
        }
    }

    private boolean filterOutByBaseContexts(LdapName targetName) {
        List<LdapName> baseContexts = this.conn.getConfiguration().getBaseContextsToSynchronizeAsLdapNames();
        if (baseContexts.isEmpty()) {
            baseContexts = this.conn.getConfiguration().getBaseContextsAsLdapNames();
        }
        return !LdapUtil.isUnderContexts(targetName, baseContexts);
    }

    private boolean filterOutByModifiersNames(Map<String, List<Object>> changes) {
        Set<LdapName> filter = this.conn.getConfiguration().getModifiersNamesToFilterOutAsLdapNames();
        if (filter.isEmpty()) {
            LOG.ok("Filtering by modifiersName disabled", new Object[0]);
            return false;
        }
        List<Object> modifiersNameValues = changes.get("modifiersName");
        if (CollectionUtil.isEmpty(modifiersNameValues)) {
            LOG.ok("Not filtering by modifiersName because not set for this entry", new Object[0]);
            return false;
        }
        LdapName modifiersName = LdapUtil.quietCreateLdapName(modifiersNameValues.get(0).toString());
        return filter.contains(modifiersName);
    }

    private boolean filterOutByAttributes(Map<String, List<Object>> attrChanges) {
        Set<String> filter = this.getAttributesToSynchronize();
        if (filter.isEmpty()) {
            LOG.ok("Filtering by attributes disabled", new Object[0]);
            return false;
        }
        Set<String> changedAttrs = attrChanges.keySet();
        return !this.containsAny(filter, changedAttrs);
    }

    private boolean filterOutByObjectClasses(List<String> objectClasses) {
        Set<String> filter = this.getObjectClassesToSynchronize();
        if (filter.isEmpty()) {
            LOG.ok("Filtering by object class disabled", new Object[0]);
            return false;
        }
        return !this.containsAny(filter, objectClasses);
    }

    private SyncDeltaType getSyncDeltaType(String changeType) {
        if ("delete".equalsIgnoreCase(changeType)) {
            return SyncDeltaType.DELETE;
        }
        return SyncDeltaType.CREATE_OR_UPDATE;
    }

    private String getModifiedEntrySearchFilter() {
        if (this.oclass.equals((Object)ObjectClass.ACCOUNT)) {
            return this.conn.getConfiguration().getAccountSynchronizationFilter();
        }
        return null;
    }

    private int getStartChangeNumber(SyncToken lastToken) {
        Integer lastTokenValue;
        Integer n = lastTokenValue = lastToken != null ? (Integer)lastToken.getValue() : null;
        if (lastTokenValue == null) {
            return this.getChangeLogAttributes().getFirstChangeNumber();
        }
        return lastTokenValue + 1;
    }

    private Map<String, List<Object>> getAttributeChanges(String changeType, String ldif) {
        SortedMap result;
        block5: {
            block4: {
                result = CollectionUtil.newCaseInsensitiveMap();
                if (!"modify".equalsIgnoreCase(changeType)) break block4;
                LdifParser parser = new LdifParser(ldif);
                Iterator<LdifParser.Line> lines = parser.iterator();
                while (lines.hasNext()) {
                    LdifParser.Line line = lines.next();
                    if (line instanceof LdifParser.Separator || line instanceof LdifParser.ChangeSeparator) continue;
                    LdifParser.NameValue nameValue = (LdifParser.NameValue)line;
                    String operation = nameValue.getName();
                    String attrName = nameValue.getValue();
                    if (!LDIF_MODIFY_OPS.contains(operation)) continue;
                    ArrayList<Object> values = new ArrayList<Object>();
                    while (lines.hasNext() && !((line = lines.next()) instanceof LdifParser.Separator)) {
                        nameValue = (LdifParser.NameValue)line;
                        Object value = this.decodeAttributeValue(nameValue);
                        if (value == null) continue;
                        values.add(value);
                    }
                    if (values.isEmpty()) continue;
                    result.put(attrName, values);
                }
                break block5;
            }
            if (!"add".equalsIgnoreCase(changeType)) break block5;
            LdifParser parser = new LdifParser(ldif);
            for (LdifParser.Line line : parser) {
                LdifParser.NameValue nameValue;
                Object value;
                if (line instanceof LdifParser.Separator || line instanceof LdifParser.ChangeSeparator || (value = this.decodeAttributeValue(nameValue = (LdifParser.NameValue)line)) == null) continue;
                ArrayList<Object> values = (ArrayList<Object>)result.get(nameValue.getName());
                if (values == null) {
                    values = new ArrayList<Object>();
                    result.put(nameValue.getName(), values);
                }
                values.add(value);
            }
        }
        return result;
    }

    private Object decodeAttributeValue(LdifParser.NameValue nameValue) {
        String value = nameValue.getValue();
        if (value.startsWith(":")) {
            String base64 = value.substring(1).trim();
            try {
                return Base64.decode((String)base64);
            }
            catch (Exception e) {
                LOG.error("Could not decode attribute {0} with Base64 value {1}", new Object[]{nameValue.getName(), nameValue.getValue()});
                return null;
            }
        }
        return value;
    }

    private String getChangeLogSearchFilter(String changeNumberAttr, int startChangeNumber) {
        int blockSize = this.conn.getConfiguration().getChangeLogBlockSize();
        boolean filterWithOrInsteadOfAnd = this.conn.getConfiguration().isFilterWithOrInsteadOfAnd();
        boolean filterByLogEntryOClass = !this.conn.getConfiguration().isRemoveLogEntryObjectClassFromFilter();
        StringBuilder result = new StringBuilder();
        if (filterWithOrInsteadOfAnd) {
            if (filterByLogEntryOClass) {
                result.append("(&(objectClass=changeLogEntry)");
            }
            result.append("(|(");
            result.append(changeNumberAttr);
            result.append('=');
            result.append(startChangeNumber);
            result.append(')');
            int endChangeNumber = startChangeNumber + blockSize;
            for (int i = startChangeNumber + 1; i <= endChangeNumber; ++i) {
                result.append("(");
                result.append(changeNumberAttr);
                result.append('=');
                result.append(i);
                result.append(')');
            }
            result.append(')');
            if (filterByLogEntryOClass) {
                result.append(')');
            }
        } else {
            result.append("(&");
            if (filterByLogEntryOClass) {
                result.append("(objectClass=changeLogEntry)");
            }
            result.append("(");
            result.append(changeNumberAttr);
            result.append(">=");
            result.append(startChangeNumber);
            result.append(')');
            int endChangeNumber = startChangeNumber + blockSize;
            result.append("(");
            result.append(changeNumberAttr);
            result.append("<=");
            result.append(endChangeNumber);
            result.append(')');
            result.append(')');
        }
        return result.toString();
    }

    ChangeLogAttributes getChangeLogAttributes() {
        if (this.changeLogAttrs == null) {
            try {
                Attributes attrs = this.conn.getInitialContext().getAttributes("", new String[]{"changeLog", "firstChangeNumber", "lastChangeNumber"});
                String changeLog = LdapUtil.getStringAttrValue(attrs, "changeLog");
                String firstChangeNumber = LdapUtil.getStringAttrValue(attrs, "firstChangeNumber");
                String lastChangeNumber = LdapUtil.getStringAttrValue(attrs, "lastChangeNumber");
                if (changeLog == null || firstChangeNumber == null | lastChangeNumber == null) {
                    String error = "Unable to locate the replication change log.\nFrom the admin console please verify that the change log is enabled under Configuration: Replication: Supplier Settings and that the Retro Change Log Plugin is enabled under Configuration: Plug-ins: Retro Change Log Plugin";
                    throw new ConnectorUnKnownException(error);
                }
                this.changeLogAttrs = new ChangeLogAttributes(changeLog, SunDSChangeLogSyncStrategy.convertToInt(firstChangeNumber, 0), SunDSChangeLogSyncStrategy.convertToInt(lastChangeNumber, 0));
            }
            catch (NamingException e) {
                throw new ConnectorUnKnownException((Throwable)e);
            }
        }
        return this.changeLogAttrs;
    }

    private String getChangeNumberAttribute() {
        String result = this.conn.getConfiguration().getChangeNumberAttribute();
        if (StringUtil.isBlank((String)result)) {
            result = "changeNumber";
        }
        return result;
    }

    private Set<String> getAttributesToSynchronize() {
        if (this.attrsToSync == null) {
            SortedSet result = CollectionUtil.newCaseInsensitiveSet();
            result.addAll(Arrays.asList(LdapUtil.nullAsEmpty(this.conn.getConfiguration().getAttributesToSynchronize())));
            if (this.conn.getConfiguration().isSynchronizePasswords()) {
                result.add(this.conn.getConfiguration().getPasswordAttributeToSynchronize());
            }
            this.attrsToSync = result;
        }
        return this.attrsToSync;
    }

    private Set<String> getObjectClassesToSynchronize() {
        if (this.oclassesToSync == null) {
            SortedSet result = CollectionUtil.newCaseInsensitiveSet();
            result.addAll(Arrays.asList(LdapUtil.nullAsEmpty(this.conn.getConfiguration().getObjectClassesToSynchronize())));
            this.oclassesToSync = result;
        }
        return this.oclassesToSync;
    }

    private PasswordDecryptor getPasswordDecryptor() {
        assert (this.passwordDecryptor != null);
        return this.passwordDecryptor;
    }

    private boolean containsAny(Set<String> haystack, Collection<String> needles) {
        for (String needle : needles) {
            if (!haystack.contains(needle)) continue;
            return true;
        }
        return false;
    }

    public static int convertToInt(String number, int def) {
        int result = def;
        if (number != null && number.length() > 0) {
            int decimal = number.indexOf(46);
            if (decimal > 0) {
                number = number.substring(0, decimal);
            }
            try {
                result = Integer.parseInt(number);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    static {
        LDIF_MODIFY_OPS.add("add");
        LDIF_MODIFY_OPS.add("delete");
        LDIF_MODIFY_OPS.add("replace");
    }
}

