/*
 * Decompiled with CFR 0.152.
 */
package com.bamboocloud.icf.connector.upstream.ad.util;

import com.bamboocloud.icf.common.logging.Log;
import com.bamboocloud.icf.common.security.GuardedString;
import com.bamboocloud.icf.framework.common.objects.Attribute;
import com.bamboocloud.icf.framework.common.objects.OperationalAttributes;
import java.nio.charset.Charset;
import java.util.List;
import javax.naming.directory.BasicAttribute;

public abstract class ADGuardedPasswordAttribute {
    private static final Log LOG = Log.getLog(ADGuardedPasswordAttribute.class);

    public static ADGuardedPasswordAttribute create(String attrName, Attribute attr) {
        assert (attr.is(OperationalAttributes.PASSWORD_NAME));
        List value = attr.getValue();
        if (value != null && !value.isEmpty()) {
            return ADGuardedPasswordAttribute.create(attrName, (GuardedString)value.get(0));
        }
        return ADGuardedPasswordAttribute.create(attrName);
    }

    public static ADGuardedPasswordAttribute create(String attrName, GuardedString password) {
        return new Simple(attrName, password);
    }

    public static ADGuardedPasswordAttribute create(String attrName) {
        return new Empty(attrName);
    }

    public abstract void access(Accessor var1);

    private static final class Simple
    extends ADGuardedPasswordAttribute {
        private final String attrName;
        private final GuardedString password;

        private Simple(String attrName, GuardedString password) {
            this.attrName = attrName;
            this.password = password;
        }

        @Override
        public void access(final Accessor accessor) {
            this.password.access(new GuardedString.Accessor(){

                public void access(char[] clearChars) {
                    String quotedPwd = "\"" + new String(clearChars) + "\"";
                    byte[] unicodePwd = quotedPwd.getBytes(Charset.forName("UTF-16LE"));
                    BasicAttribute attr = new BasicAttribute(attrName, unicodePwd);
                    accessor.access(attr);
                }
            });
        }
    }

    private static final class Empty
    extends ADGuardedPasswordAttribute {
        private final String attrName;

        private Empty(String attrName) {
            this.attrName = attrName;
        }

        @Override
        public void access(Accessor accessor) {
            accessor.access(new BasicAttribute(this.attrName));
        }
    }

    public static interface Accessor {
        public void access(BasicAttribute var1);
    }
}

